<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Acesso Cupom</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.261.6.2">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.261.6.2">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.261.6.2">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.261.6.2">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.261.6.2" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.261.6.2">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.261.6.2" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.261.6.2">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.261.6.2">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.261.6.2">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.261.6.2">
  <style>
    .bordaCampos {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 2%;
      padding-bottom: 0%;
    }

    .bordaCampos:first-child {
      display: flex;
      flex-direction: row;
      flex-wrap: wrap;
      justify-content: flex-end;
      align-items: center;
    }

    .border-Field .textoBorda {
      font-size: 1.0em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1.0px solid var(--font-color) !important;
      padding: 0 1.0em 1.0em 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      padding-bottom: 0px !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Cupom de Desconto</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">

            </div>
          </div>
        </div>
        <div class="container-fluid" id="tabelaCupomBtn">
          <div class="row card">
            <div class="col-sm-12 mt-3">
              <button class="btn btn-success btn-sisp" id="btn-filtros"><span class="fas fa-search"></span> Filtros</button>
              <button class="btn btn-danger btn-sisp" id="btnNovoCupom"><span class="fa fa-plus"></span> Incluir</button>
              <button class="btn btn-secondary btn-sisp" id="btnImprimir" data-toggle="modal"><i class="fas fa-print"></i> Imprimir</button>
            </div>

            <div class="col-sm-12 table-responsive card-body">
              <h5>Lista de Cupons de Desconto</h5>
              <table id="tabelaCupom" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm">CODIGO
                    </th>
                    <th class="th-sm">DESCRICAO
                    </th>
                    <th class="th-sm">CODCLI
                    </th>
                    <th class="th-sm">NOME
                    </th>
                    <th class="th-sm">PERC_DESC
                    </th>
                    <th class="th-sm">VALOR_DESC
                    </th>
                    <th class="th-sm">DT_INICIO
                    </th>
                    <th class="th-sm">DT_FIM
                    </th>
                    <th class="th-sm">QUANTIDADE
                    </th>
                    <th class="th-sm">QUANTIDADE UTILIZADA
                    </th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>

          </div>
        </div>
        <div class="modal" id="modal-filtros">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title">Filtros
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body" id="modal-conteudo">
                <form id="msform2" name="msform2">
                  <div class="row">
                    <div class="col-lg-6 col-12 m-6 form-group">
                      <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="dtInicio">Data de inicio: </label>
                      <div class="relative" style="margin-top: 5px;">
                        <div class="input-group">
                          <input max="2500-12-31" type="date" value="1200-01-01" class="input-default focus form-control" id="dtInicio" name="dtInicio" class="form-control">
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6 col-12 m-6 form-group">
                      <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="dtFim">Data final: </label>
                      <div class="relative" style="margin-top: 5px;">
                        <div class="input-group">
                          <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control" id="dtFim" name="dtFim" class="form-control">
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6 col-12 m-6 form-group">
                      <label data-error="wrong" data-success="right" for="txtCodigo">Cód. Cupom:</label>
                      <div class="input-group">
                        <input type="text" class="input-default focus form-control" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="Código">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-codigo-filtro" name="btn-codigo-filtro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-codigo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6 col-12 m-6 form-group">
                      <label data-error="wrong" data-success="right" for="txtCliente">Cliente:</label>
                      <div class="input-group">
                        <select class="js-example-programmatic js-states form-control" id="txtCliente" name="txtCliente" multiple="multiple"></select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6 col-12 m-6 form-group">
                      <fieldset class="form border-Field p-0">
                        <legend class="textoBorda pb-0 mb-0">Status</legend>
                        <div class="d-flex">
                          <div class="icheck-primary mr-3"><input type="radio" id="rdStatusTodos" checked name="rdFiltroStatus" value="0"><label class="labelCheck" for="rdStatusTodos">Todos</label></div>
                          <div class="icheck-primary mr-3"><input type="radio" id="rdStatusPendentes" name="rdFiltroStatus" value="1"><label class="labelCheck" for="rdStatusPendentes">Pendentes</label></div>
                          <div class="icheck-primary"><input type="radio" id="rdStatusUtilizados" name="rdFiltroStatus" value="2"><label class="labelCheck" for="rdStatusUtilizados">Utilizados</label></div>
                      </fieldset>
                    </div>
                </form>
              </div>
            </div>
            <div class="modal-footer">
              <div class="row">
                <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../../modais.php');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.261.6.2"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.261.6.2"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/adminlte.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/sisplan.js?versao=3.261.6.2"></script>
  <script src="utils/funcoes.js?versao=3.261.6.2"></script>
  <script src="utils/cookies.js?versao=3.261.6.2"></script>
  <script src="dist/js/requisicoes.js?versao=3.261.6.2"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/driver.min.js?versao=3.261.6.2"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="config.js?versao=3.261.6.2"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.261.6.2"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('CADCUPOMDESCONTO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/cadcupomdesconto/acesso_cadcupomdesconto/acesso_cadcupomdesconto.js?versao=3.261.6.2`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>